#!/usr/bin/env python
# -*- coding: utf-8 -*-
from iViewXAPI import  *            #iViewX library
from iViewXAPIReturnCodes import * 

# ---------------------------------------------
#---- connect to iViewX
# ---------------------------------------------

res = iViewXAPI.iV_SetLogger(c_int(1), c_char_p("iViewXSDK_Python_SimpleExperiment.txt"))
res = iViewXAPI.iV_Connect(c_char_p('127.0.0.1'), c_int(4444), c_char_p('127.0.0.1'), c_int(5555))
if res != 1:
    HandleError(res)
    exit(0)

res = iViewXAPI.iV_GetSystemInfo(byref(systemData))
print "iV_GetSystemInfo: " + str(res)
print "Samplerate: " + str(systemData.samplerate)
print "iViewX Verion: " + str(systemData.iV_MajorVersion) + "." + str(systemData.iV_MinorVersion) + "." + str(systemData.iV_Buildnumber)
print "iViewX API Verion: " + str(systemData.API_MajorVersion) + "." + str(systemData.API_MinorVersion) + "." + str(systemData.API_Buildnumber)

# ---------------------------------------------
#---- configure and start calibration
# ---------------------------------------------

calibrationData = CCalibration(5, 1, 0, 0, 1, 250, 220, 2, 20, b"")

res = iViewXAPI.iV_SetupCalibration(byref(calibrationData))
print "iV_SetupCalibration " + str(res)
res = iViewXAPI.iV_Calibrate()
print "iV_Calibrate " + str(res)

res = iViewXAPI.iV_Validate()
print "iV_Validate " + str(res)

res = iViewXAPI.iV_GetAccuracy(byref(accuracyData), 0)
print "iV_GetAccuracy " + str(res)
print "deviationXLeft " + str(accuracyData.deviationXLeft) + " deviationYLeft " + str(accuracyData.deviationYLeft)
print "deviationXRight " + str(accuracyData.deviationXRight) + " deviationYRight " + str(accuracyData.deviationYRight)

iViewXAPI.iV_ShowTrackingMonitor()
print "iV_ShowTrackingMonitor " + str(res)

# ---------------------------------------------
#---- run the trial
# ---------------------------------------------

#output 1000 samples
a = 0;
while a < 1000:
    #update gaze data sample
    res = iViewXAPI.iV_GetSample(byref(sampleData))
    if res == 1:
        a = a+1
        print str(a) + ": Gaze Data - Timestamp " + str(sampleData.timestamp) + " Gaze " + str(sampleData.leftEye.gazeX) + " " + str(sampleData.leftEye.gazeY)

    res = iViewXAPI.iV_GetEvent(byref(eventData))
    if res == 1:
        print str(a) + ": Event: " + str(eventData.positionX) + " " + str(eventData.positionY)

# ---------------------------------------------
#---- stop recording and disconnect from iViewX
# ---------------------------------------------

res = iViewXAPI.iV_Disconnect()
