import obspython as obs
import urllib.request
import urllib.error
import subprocess
import os

output_dir = f"{obs.obs_frontend_get_current_record_output_path()}/Audio"
ffmpeg_path = "" #TODO: allow specify ffmpeg instance

# ------------------------------------------------------------

def get_latest_recording():
	path = obs.obs_frontend_get_current_record_output_path()
	print (path)
	files = os.listdir(path)
	paths = [os.path.join(path, basename) for basename in files if basename.endswith('.mkv')]
	return max(paths, key=os.path.getctime)

def extract_audio_channels(path):
	global output_dir

	# Get audio channel configuration from ffprobe. Expected to return "<streamId>|<numChannels>|<streamTitle>"
	cmd = f'ffprobe -v error -select_streams a -show_entries stream_tags=title:stream=index,channels -of compact=p=0:nk=1 "{path}"'
	output = subprocess.run(cmd, check=True, capture_output=True, text=True)

	if (output.stdout is None or output.stdout == ""):
		print("Error: no audio channels detected")
		return

	file_name = os.path.splitext(os.path.basename(path))[0]

	if not os.path.exists(output_dir):
		os.mkdir(output_dir)

    # Extract each channel from each stream individually
	for stream in output.stdout.splitlines():
		idx, chans, stream_name = stream.split('|')
		for i in range(int(chans)):
			print(f'Extracting stream {idx} ({stream_name}) channel {i}...')
			cmd = f'ffmpeg -i "{path}" -map 0:a:{int(idx)-1} -af "pan=mono|c0=c{i}" -y "{output_dir}\\{file_name}_{stream_name}_{i}.wav"'
			subprocess.run(cmd)

def signal_catcher(cd):
	path = get_latest_recording()
	extract_audio_channels(path)

# ------------------------------------------------------------

def script_description():
	return "Automatically extract individual audio channels from recording.\n\
Requires ffmpeg. \nExpects recordings to be saved as MKV."

def script_load(settings):	
	# Subscribe to recording finish event
	output = obs.obs_frontend_get_recording_output()
	sh = obs.obs_output_get_signal_handler(output)
	obs.signal_handler_connect(sh, "deactivate", signal_catcher)

def script_defaults(settings):
	global output_dir	
	obs.obs_data_set_default_string(settings, "outputdir", output_dir)

def script_update(settings):
	global output_dir
	output_dir = obs.obs_data_get_string(settings, "outputdir")

def script_properties():
	global output_dir
	props = obs.obs_properties_create()	
	obs.obs_properties_add_path(props, "outputdir", "Output folder", obs.OBS_PATH_DIRECTORY, "", output_dir)

	return props
